/*
 *  ======== main.c ========
 */

/*
 *  ======== Include files ========
 */
#include <csl.h>
#include <csl_edma.h>
#include <csl_irq.h>
#include <csl_mcbsp.h>

#include "edma.h"
#include "mcbsp.h"

/*
 *  ======== Declarations ========
 */
#define BUFFSIZE 512

/*
 *  ======== Prototypes ========
 */
void initHwi(void);

/*
 *  ======== Global Variables ========
 */
short gBufRcvLtPing[BUFFSIZE];
short gBufRcvRtPing[BUFFSIZE];
short gBufRcvLtPong[BUFFSIZE];
short gBufRcvRtPong[BUFFSIZE];
short gBufXmtLtPing[BUFFSIZE];
short gBufXmtRtPing[BUFFSIZE];
short gBufXmtLtPong[BUFFSIZE];
short gBufXmtRtPong[BUFFSIZE];



/*
 *  ======== main ========
 */
void main()
{
    int i;
    
    for (i=0; i < BUFFSIZE; i++) {	// zero out Xmt buffers (prior to enable)
    	gBufXmtLtPing[i] = 0;	
		gBufXmtLtPong[i] = 0;
		gBufXmtRtPing[i] = 0;
		gBufXmtRtPong[i] = 0;
	}


        
	initMcBSP();
	initEdma();

	// Starts the transmitter
	MCBSP_write(hMcbspData,0);

	initHwi();						// initialize Hardware Interrputs

    while (1) {						// Loop Forever
    }
}

/*
 *	======== initHwi ========
 */
void initHwi(void)
{
	IRQ_enable(IRQ_EVT_EDMAINT);	//enable EDMA interrupt to CPU (IER)
	
	IRQ_globalEnable();				//turn on global interrupts (GIE)
}
